////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  PDFPolygonInfo.h
//    A collection of points used for the PDF function calls.
//
//  Copyright © 2010-2012 Acclivity Group LLC, all rights reserved.
//
//  Change History (most recent first):
//
//	09/30/10  K.L.S.  Created file.
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "CrossPlatform/CrossPlatform.h"

class EXTERNAL_API PDFPolygonInfo
{
public:
	PDFPolygonInfo(void);
	virtual ~PDFPolygonInfo(void);
	
	void AddPoint(const CPPoint& Point);
	CPPoint PointAtIndex(CPUInteger Index) const;
	CPUInteger Count(void) const;
	CPData Data(void) const;
	
private:
	CPData m_Data;
	CPUInteger m_Count;
};
